/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Map;
import org.sonar.api.internal.apachecommons.collections.SortedBag;
import org.sonar.api.internal.apachecommons.collections.bag.TreeBag;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.math.NumberUtils;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureBuilder;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.SonarException;

public class CountDistributionBuilder
implements MeasureBuilder {
    private Metric metric;
    private SortedBag countBag;

    public CountDistributionBuilder(Metric metric) {
        this.setMetric(metric);
        this.countBag = new TreeBag();
    }

    public CountDistributionBuilder add(Object value, int count) {
        if (count == 0) {
            this.addZero(value);
        } else if (this.countBag.add(value, count)) {
            this.countBag.add(value, 1);
        }
        return this;
    }

    public CountDistributionBuilder add(Object value) {
        return this.add(value, 1);
    }

    public CountDistributionBuilder addZero(Object value) {
        if (!this.countBag.contains(value)) {
            this.countBag.add(value, 1);
        }
        return this;
    }

    public CountDistributionBuilder add(Measure measure) {
        if (measure != null && measure.getData() != null) {
            Map<String, String> map = KeyValueFormat.parse(measure.getData());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                int value;
                String key = entry.getKey();
                int n = value = StringUtils.isBlank(entry.getValue()) ? 0 : Integer.parseInt(entry.getValue());
                if (NumberUtils.isNumber(key)) {
                    this.add(NumberUtils.toInt(key), value);
                    continue;
                }
                this.add(key, value);
            }
        }
        return this;
    }

    public boolean isEmpty() {
        return this.countBag.isEmpty();
    }

    public CountDistributionBuilder clear() {
        this.countBag.clear();
        return this;
    }

    @Override
    public Measure build() {
        return this.build(true);
    }

    public Measure build(boolean allowEmptyData) {
        if (!this.isEmpty() || allowEmptyData) {
            return new Measure(this.metric, KeyValueFormat.format(this.countBag, -1));
        }
        return null;
    }

    private void setMetric(Metric metric) {
        if (metric == null || !metric.isDataType()) {
            throw new SonarException("Metric is null or has unvalid type");
        }
        this.metric = metric;
    }
}

